<?php
namespace App\Console\Commands;


use Exception;
use Carbon\Carbon;
use Illuminate\Console\Command;

class InvoicerInstall extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'invoicer:install';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Configure a fresh database, ready to use.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $start = new Carbon();
        $this->info('Iniciando recarregamento da Base de dados');
        $this->alert('Recriando base de dados');
        try {
            $this->call('session:table');
        } catch (Exception $e) {
            // throw ;
        }
        $this->call('migrate:fresh', [
            '--force'
        ]); //Inclui as tabelas do passport

        $this->alert('Base de dados recriada inicio ' . $start->diffForHumans());

        $this->alert('Instalando passport');
        $this->call('passport:install');
        $this->alert('Passport Instalado');
    }
}
