<?php

namespace App\Console\Commands;


use Carbon\Carbon;
use Illuminate\Console\Command;

class InvoicerReloadDatabase extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'invoicer:reload {--fake : Indicates to run fake seeder}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Reloads the database running: migrate:fresh and db:seed';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {

        $start = new Carbon();
        $this->call('invoicer:install');


        $this->alert('Semeando registros');
        $this->call('db:seed', [
            '--force'
        ]);
        $this->alert('Registros semeados ha ' . $start->diffForHumans());

        $this->alert('Seeding Initial Data');
        $this->call('db:seed', [
            '--class' => 'InitialSeeder',
             '--force'
        ]);
        $this->info('Initial data seeded successfully');

        if ($this->option('fake')) {
            $this->alert('Seeding Fake Data');
            $this->call('invoicer:fake');
            $this->info('Fake data seeded successfully');
        }

        $this->info('Base de dados recarregada');

        $this->alert('execução Iniciada ha ' . $start->diffForHumans());
    }
}
