<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $company = request()->user()->company;

        $saleables = collect([]);

        $all_saleable =  $company->saleables()->paginate(10);


        foreach ($all_saleable  as $key => $prod) {

            $onSotck = DB::table('stock_moves')->where('saleable_id', $prod->id)->
            where('balance', '<', $company->stock_alert)->latest('created_at')->first();

            if($onSotck!=null){

                    $product =  $company->saleables()->find($onSotck->saleable_id);

                    $saleables->push((object)[
                        'id' => $product->id,
                        'code'=>$product->code,
                        'name'=> $product->name,
                        'qty'=>  $onSotck->balance,
                        'price' => $product->price
                    ]);
            }



        }



        if (request()->user()->isJustSeller())
            return  redirect()->route('web.sales.basic.create');
        return view('dashboard.index', [
            'company' => $company,
            'saleables' => $saleables
        ]);
    }
}
