<?php

namespace App\Http\Controllers\api\company;

use Illuminate\Http\Request;
use App\models\company\Brunch;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Gate;
use App\models\company\BasicSaleOption;
use Symfony\Component\HttpFoundation\Response;

class BasicSaleOptionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, Brunch $brunch)
    {
        abort_if(Gate::denies('manage-brunch', $brunch), Response::HTTP_FORBIDDEN);

        $opt = $brunch->basicSaleOption ?? new BasicSaleOption();
        $opt->company()->associate($brunch);
        $opt->fast_sale = ($request->input('sale_type') == 'normal') ? 0 : 1;
        $opt->save();

        return response()->json([
            'message' => 'OK',
        ], Response::HTTP_CREATED);
    }
}
