<?php

namespace App\Http\Controllers\api\company;

use App\models\company\Brunch;
use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Storage;
use App\models\company\CompanyVatScheme;
use App\Http\Requests\company\BrunchRequest;
use Symfony\Component\HttpFoundation\Response;
use App\Http\Requests\company\BrunchPhotoRequest;

class BrunchController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    public function photo(BrunchPhotoRequest $request, Brunch $brunch)
    {
        abort_if(Gate::denies('manage-brunch', $brunch), Response::HTTP_FORBIDDEN);

        if ($request->hasFile('file')) {
            $old = $brunch->logo;
            $file = Storage::disk('public')->put('company/logo', $request->file('file'));
            $brunch->logo = $file;
            $brunch->save();

            if (Storage::disk('public')->exists($old))
                Storage::disk('public')->delete([$old]);
            return response()->json([
                'message' => 'OK',
            ], Response::HTTP_CREATED);
        } else
            return response()->json([
                'message' => 'OK',
            ], Response::HTTP_UNPROCESSABLE_ENTITY);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(BrunchRequest $request)
    {
        $brunch = new Brunch();
        $brunch->name = $request->input('name');
        $brunch->country = $request->input('country');
        $brunch->city = $request->input('city');
        $brunch->address = $request->input('address');
        $brunch->phone = $request->input('phone');
        $brunch->email = $request->input('email');
        $brunch->nuit = $request->input('nuit');
        $brunch->daf_auth = $request->input('daf_auth');
        $brunch->vatScheme()->associate(CompanyVatScheme::find($request->input('vat_scheme')));
        $brunch->save();
        $brunch->funcionalities()->attach($request->input('funcionalities'));

        $brunch->runDefaults();

        return response()->json([
            'message' => 'OK',
            'url' => [
                'web' => URL::route('web.company.brunch.show', ['brunch' => $brunch->id])
            ]
        ], Response::HTTP_CREATED);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(BrunchRequest $request, Brunch $brunch)
    {
        //
        abort_if(Gate::denies('manage-brunch', $brunch), Response::HTTP_FORBIDDEN);

        $brunch->name = $request->input('name');
        $brunch->country = $request->input('country');
        $brunch->city = $request->input('city');
        $brunch->address = $request->input('address');
        $brunch->phone = $request->input('phone');
        $brunch->email = $request->input('email');
        $brunch->nuit = $request->input('nuit');
        $brunch->daf_auth = $request->input('daf_auth');
        $brunch->bank_data_footer = $request->input('bank_data_footer');

        $brunch->vatScheme()->associate(CompanyVatScheme::find($request->input('vat_scheme')));
        $brunch->save();

        if ($request->filled('funcionalities')) {
            $brunch->funcionalities()->sync($request->input('funcionalities'));
        }


        return response()->json([
            'message' => 'OK',
            'url' => [
                'web' => URL::route('web.company.brunch.show', ['brunch' => $brunch->id])
            ]
        ], Response::HTTP_ACCEPTED);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Brunch $brunch)
    {
        //
        abort_if(!request()->user()->can('manage-global'), Response::HTTP_FORBIDDEN);

        $brunch->forceDelete();

        return response()->json([
            'message' => 'OK',
        ], Response::HTTP_NO_CONTENT);
    }
}
