<?php

namespace App\Http\Controllers\api\company\crm;

use App\models\company\Brunch;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Gate;
use App\models\company\crm\CRMConfiguration;
use Symfony\Component\HttpFoundation\Response;
use App\Http\Requests\company\crm\CRMConfigurationRequest;

class CRMConfigurationController extends Controller
{

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(CRMConfigurationRequest $request, Brunch $brunch)
    {
        abort_if(Gate::denies('manage-brunch', $brunch), Response::HTTP_FORBIDDEN);
        abort_if(Gate::denies('funcionality-crm', $brunch), Response::HTTP_FORBIDDEN);

        $crmconfig =  $brunch->crmConfig ??  new CRMConfiguration();
        if (!$request->input('enable', false))
            $crmconfig->enabled_at = null;
        else {
            $crmconfig->enabled_at = now();
            $crmconfig->increment_amount = $request->input('increment_amount');
            $crmconfig->point_amount = $request->input('point_amount');
        }
        $crmconfig->company()->associate($brunch);
        $crmconfig->save();
        return response()->json([
            'message' => 'OK'
        ], Response::HTTP_ACCEPTED);
    }
}
