<?php

namespace App\Http\Controllers\api\customers;

use Illuminate\Http\Request;
use App\models\customers\Customer;
use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;
use Symfony\Component\HttpFoundation\Response;
use App\Http\Requests\customers\CustomerRequest;
use App\Http\Requests\customers\BillsSearchRequest;
use App\Http\Resources\sales\GeneralSaleCollection;
use App\Http\Resources\customers\CustomerCollection;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Arr;

class CustomerController extends Controller
{
    public function searchBills(BillsSearchRequest $request)
    {

        $customer = Customer::find($request->input('customer'));
        abort_if(!request()->user()->can('view', $customer), Response::HTTP_FORBIDDEN);

        $amount = $request->input('amount');

        $bills = $customer->getBills($amount);
        $bills2 = $customer->getBillsInvoiceByDelivery($amount);

        $all = Arr::collapse([$bills, $bills2]);
        
        return new GeneralSaleCollection($all);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $company = $request->user()->company;
        return new CustomerCollection($company->customers);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(CustomerRequest $request)
    {
        if ($request->hasFile('file')) {
            return response()->json([
                'message' => 'OK',
            ], Response::HTTP_CREATED);
        }

        $company = $request->user()->company;
        $last = DB::table('customers')->where('brunch_company_id', $company->id)->latest('created_at')->first();

        $customer  = new Customer();
        $customer->code = 'C' . $company->id . 'CC'.($last->id + 1);
        $customer->name = $request->input('name');
        $customer->nuit = $request->input('nuit');
        $customer->phone = $request->input('phone');
        $customer->discount = $request->input('discount');
        $customer->address = $request->input('address');
        $customer->company()->associate($company);
        $customer->save();

        return response()->json([
            'message' => 'OK',
            'url' => [
                'web' => URL::route('web.customer.show', ['customer' => $customer->id])
            ]
        ], Response::HTTP_CREATED);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Customer $customer)
    {
        abort_if(!request()->user()->can('update', $customer), Response::HTTP_FORBIDDEN);
        $customer->name = $request->input('name');
        $customer->nuit = $request->input('nuit');
        $customer->phone = $request->input('phone');
        $customer->discount = $request->input('discount');

        $customer->save();

        return response()->json([
            'message' => 'OK',
            'url' => [
                'web' => URL::route('web.customer.show', ['customer' => $customer->id])
            ]
        ], Response::HTTP_ACCEPTED);
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Customer $customer)
    {
        abort_if(!request()->user()->can('delete', $customer), Response::HTTP_FORBIDDEN);

        $customer->forceDelete();

        return response()->json([
            'message' => 'OK',
        ], Response::HTTP_NO_CONTENT);
    }
}
