<?php

namespace App\Http\Controllers\api\customers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use App\models\customers\Customer;
use App\Http\Controllers\Controller;
use Symfony\Component\HttpFoundation\Response;
use App\Http\Requests\customers\CustomerOperationRequest;
use App\Http\Resources\customers\CustomerOperationResourceCollection;

class CustomerOperationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(CustomerOperationRequest $request, Customer $customer)
    {
        abort_if(!request()->user()->can('view', $customer), Response::HTTP_FORBIDDEN);

        $query =  $customer->customerOperations();

        if ($request->filled('from')) {
            $from   = (new Carbon($request->input('from')))->startOfDay();
            $query = $query->whereDate('validated_at', '>=', $from);
        }

        if ($request->filled('to')) {
            $to     = (new Carbon($request->input('to')))->endOfDay();
            $query = $query->whereDate('validated_at', '<=', $to);
        }

        $take   = $request->input('take', 20);
        $results = $query->orderBy('id', 'DESC')
            ->take($take)->get()
            ->sortBy('id');
        return new CustomerOperationResourceCollection($results);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
