<?php

namespace App\Http\Controllers\api\provider;


use Illuminate\Http\Request;
use App\models\stock\Provider;
use App\models\provider\Expense;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use App\models\provider\ExpenseAttachment;
use App\Http\Requests\stock\ExpenseRequest;
use Symfony\Component\HttpFoundation\Response;
use App\Http\Requests\DocumentAttachmentRequest;
use App\Http\Requests\provider\PurchasePaymentRequest;
use App\Http\Resources\models\provider\ExpenseResource;

class ExpensesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ExpenseRequest $request, Provider $provider)
    {
        $expense = new Expense();
        $expense->amount = $request->input('amount');
        $expense->reference = $request->input('reference');
        $expense->description = $request->input('description');
        $expense->save();

        $expense->validate($provider);

        return response()->json(
            new ExpenseResource($expense),
            Response::HTTP_CREATED
        );
    }
    public function pay(PurchasePaymentRequest $request, Provider $provider,  Expense $expense)
    {

        abort_if(!request()->user()->can('view', $provider), Response::HTTP_FORBIDDEN);
        abort_if(!request()->user()->can('view', $expense), Response::HTTP_FORBIDDEN);


        abort_if(!$provider->is($expense->provider), Response::HTTP_UNPROCESSABLE_ENTITY);
        abort_if(!$expense->isValid(), Response::HTTP_UNPROCESSABLE_ENTITY);
        abort_if($expense->isPaid(), Response::HTTP_UNPROCESSABLE_ENTITY);

        $amount = $request->input('amount');
        $reference = $request->input('reference');
        $pending = $expense->pendingAmount();

        abort_if($amount > $pending, Response::HTTP_UNPROCESSABLE_ENTITY);

        $expense->pay($amount, null, $reference);

        return response()->json(new ExpenseResource($expense), Response::HTTP_ACCEPTED);
    }

    public function attachment(DocumentAttachmentRequest $request, Provider $provider,  Expense $expense)
    {
        abort_if(!request()->user()->can('view', $provider), Response::HTTP_FORBIDDEN);
        abort_if(!request()->user()->can('view', $expense), Response::HTTP_FORBIDDEN);
        abort_if(!$provider->is($expense->provider), Response::HTTP_UNPROCESSABLE_ENTITY);
        abort_if(!$expense->isValid(), Response::HTTP_UNPROCESSABLE_ENTITY);

        if ($request->hasFile('file')) {
            $file = Storage::disk('public')->put('expense/' . $expense->id . '/attachments', $request->file('file'));


            $attachment = new ExpenseAttachment();
            $attachment->expense()->associate($expense);
            $attachment->url = $file;
            $attachment->save();


            return response()->json(new ExpenseResource($expense), Response::HTTP_ACCEPTED);
        } else
            return response()->json([
                'message' => 'OK',
            ], Response::HTTP_UNPROCESSABLE_ENTITY);
    }
}
