<?php

namespace App\Http\Controllers\api\provider;

use Illuminate\Http\Request;
use App\models\stock\Provider;
use App\models\provider\Purchase;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use App\models\provider\PurchaseAttachment;
use Symfony\Component\HttpFoundation\Response;
use App\Http\Requests\provider\PurchaseRequest;
use App\Http\Requests\DocumentAttachmentRequest;
use App\Http\Requests\provider\PurchasePaymentRequest;
use App\Http\Resources\models\provider\PurchaseResource;

class PurchaseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Provider $provider)
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, Provider $provider)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Provider $provider,  Purchase $purchase)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(PurchaseRequest $request, Provider $provider,  Purchase $purchase)
    {
        abort_if(!request()->user()->can('view', $provider), Response::HTTP_FORBIDDEN);
        // abort_if(!request()->user()->can('view', $purchase), Response::HTTP_FORBIDDEN);
        // abort_if(!$provider->is($purchase->provider), Response::HTTP_UNPROCESSABLE_ENTITY);

        $purchase->name = $request->input('document');
        $purchase->financial_discount = $request->input('financial_discount');
        $purchase->validate($provider);
        $purchase->validateMoves();
        return response()->json(new PurchaseResource($purchase), Response::HTTP_ACCEPTED);
    }

    public function pay(PurchasePaymentRequest $request, Provider $provider,  Purchase $purchase)
    {
        abort_if(!request()->user()->can('view', $provider), Response::HTTP_FORBIDDEN);
        abort_if(!request()->user()->can('view', $purchase), Response::HTTP_FORBIDDEN);
        abort_if(!$provider->is($purchase->provider), Response::HTTP_UNPROCESSABLE_ENTITY);
        abort_if(!$purchase->isValid(), Response::HTTP_UNPROCESSABLE_ENTITY);
        abort_if($purchase->isPaid(), Response::HTTP_UNPROCESSABLE_ENTITY);


        $amount = $request->input('amount');
        $reference = $request->input('reference');
        $pending = $purchase->pendingAmount();

        abort_if($amount > $pending, Response::HTTP_UNPROCESSABLE_ENTITY);

        $purchase->pay($amount, null, $reference);

        return response()->json(new PurchaseResource($purchase), Response::HTTP_ACCEPTED);
    }

    public function attachment(DocumentAttachmentRequest $request, Provider $provider,  Purchase $purchase)
    {
        // abort_if(!request()->user()->can('view', $provider), Response::HTTP_FORBIDDEN);
        // abort_if(!request()->user()->can('view', $purchase), Response::HTTP_FORBIDDEN);
        // abort_if(!$provider->is($purchase->provider), Response::HTTP_UNPROCESSABLE_ENTITY);
        abort_if($purchase->isValid(), Response::HTTP_UNPROCESSABLE_ENTITY);

        if ($request->hasFile('file')) {
            $file = Storage::disk('public')->put('purchase/' . $purchase->id . '/attachments', $request->file('file'));
            $attachment = new PurchaseAttachment();
            $attachment->purchase()->associate($purchase);
            $attachment->url = $file;
            $attachment->save();
            // return response()->json(new PurchaseResource($purchase), Response::HTTP_ACCEPTED);
            return response()->json([
                'message' => 'OK',
            ], Response::HTTP_CREATED);
        } else
            return response()->json([
                'message' => 'OK',
            ], Response::HTTP_UNPROCESSABLE_ENTITY);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Provider $provider,  Purchase $purchase)
    {
        //
    }
}
