<?php

namespace App\Http\Controllers\api\sales;

use Illuminate\Http\Request;
use App\models\sales\Invoice;
use App\models\sales\InvoicesbyDelivery;
use App\models\sales\Receipt;
use App\models\sales\DebitNote;
use App\Http\Controllers\Controller;
use App\models\sales\utils\BankPayment;
use App\models\sales\utils\PaymentMethod;
use App\models\sales\utils\AdvancePayment;
use App\Http\Requests\sales\ReceiptRequest;
use App\Http\Resources\sales\ReciptResource;
use Symfony\Component\HttpFoundation\Response;

class ReceiptController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(ReceiptRequest $request, Receipt $recipt)
    {
        abort_if(!$recipt->canBeChanged(), Response::HTTP_FORBIDDEN);
        abort_if(!request()->user()->can('update', $recipt), Response::HTTP_FORBIDDEN);
        $user = request()->user();
        $paymentMethod = PaymentMethod::find($request->input('payment_method'));
        $amount = $request->input('amount');
        $obs =  $request->input('obs');
        $bank_name = $request->input('bank_name');
        $bank_document_nr = $request->input('bank_document_nr');

        $items = $request->input('items', []);
        $bills = collect([]);

        $fail = false;

        foreach ($items as $key => $value) {
            $valores = explode('-', $value);
            $tipo  = $valores[0];
            $chave = $valores[1];

            if ($tipo == 'F') {
                $inv = Invoice::find($chave);
                if ($inv) {
                    if ($inv->company->is($user->company))
                        $bills->push($inv);
                    else
                        $fail = true;
                } else
                    $fail = true;
            } else if ($tipo == 'N') {
                $inv = DebitNote::find($chave);
                if ($inv) {
                    if ($inv->company->is($user->company))
                        $bills->push($inv);
                    else
                        $fail = true;
                } else
                    $fail = true;
            }else if ($tipo == 'FG') {

                $inv = InvoicesbyDelivery::find($chave);

                if ($inv) {
                    if ($inv->company->is($user->company))
                        $bills->push($inv);
                    else
                        $fail = true;
                } else
                    $fail = true;
            }
             else {
                $fail = true;
            }

            if ($fail)
                return response()->json([
                    'message' => 'Documentos nao encontrados', 'errors' => []
                ], Response::HTTP_UNPROCESSABLE_ENTITY);
        }

        $customer = $bills->first()->customer;
        $providerFlow = false;
        if ($paymentMethod->is(PaymentMethod::providerAdvance())) {
            $provider = $customer->provider;
            abort_if(!$provider, Response::HTTP_UNPROCESSABLE_ENTITY);
            $amount = $provider->totalInDept();
        } else if ($paymentMethod->is(PaymentMethod::systemadvance())) {
            $amount = $customer->availableAdvanceAmount();

            if ($amount <= 0)
                return response()->json([
                    'message' => 'Valor adiantado pelo cliente indisponivel', 'errors' => []
                ], Response::HTTP_UNPROCESSABLE_ENTITY);

            $ca = $customer->unusedAdvences()->first();
            $amount = $ca->amount;

            $value = new AdvancePayment();
            $value->customerAdvance()->associate($ca);
            $value->receipt()->associate($recipt);
            $value->amount = $amount;
            $value->save();

            $ca->used_at = now();
            $ca->save();
        } else if (
            ($paymentMethod->is(PaymentMethod::bankcheck()) or
                $paymentMethod->is(PaymentMethod::banktransfer()))
        ) {
            $bankPayment = new BankPayment();
            $bankPayment->bank_name = $bank_name;
            $bankPayment->document_nr = $bank_document_nr;
            $bankPayment->save();
            $recipt->bankPayment()->associate($bankPayment);
        }

        $payables = collect([]);
        if ($amount <= 0){
            $payables = $bills;
        }
        else if (!$this->canPay($bills, $amount)) {
            if ($amount <= 0)
                return response()->json([
                    'message' => 'Valor determinado insuficiente para pagar documentos escolhidos',
                    'errors' => []
                ], Response::HTTP_UNPROCESSABLE_ENTITY);
        }

        $recipt->paymentMethod()->associate($paymentMethod);
        $payables = $bills;
        $recipt->obs = $obs;
        $recipt->finalize($payables, $amount);
        return response()->json(new ReciptResource($recipt), Response::HTTP_ACCEPTED);


    }

    private function canPay($invoices, $amount = 0)
    {
        $invoices = $invoices->filter(function ($item) use (&$amount) {
            if ($amount <= 0)
                return false;
            $amount = $amount - $item->pendingAmount();
            return true;
        });
        return true;
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
