<?php

namespace App\Http\Controllers\api\sales;


use Exception;
use Carbon\Carbon;
use App\models\company\Brunch;
use App\Http\Controllers\Controller;
use App\models\company\SystemFuncionality;
use Symfony\Component\HttpFoundation\Response;

class ReportController extends Controller
{
    public function last30DaysSales(Brunch $company)
    {
        $from = ((new Carbon())->subMonth())->startOfDay();
        $to = new Carbon();
        return $this->generateReport($company, $from, $to, true);
    }

    public function last12MonthsSales(Brunch $company)
    {
        $from = ((new Carbon())->subYear())->startOfMonth();
        $to = new Carbon();
        return $this->generateReport($company, $from, $to, false, false, true);
    }

    public function last7DaysSales(Brunch $company)
    {
        $from = ((new Carbon())->subWeek())->startOfDay();
        $to = new Carbon();
        return $this->generateReport($company, $from, $to, true, false, false);
    }


    public function currentMonth(Brunch $company){
        $from = (new Carbon())->startOfMonth();
        $to = new Carbon();
        return $this->generateReport($company, $from, $to, false, false, true);
    }

    public function thisYearSales(Brunch $company)
    {
        $from = (new Carbon())->startOfYear();
        $to = new Carbon();
        return $this->generateReport($company, $from, $to, false, false, true);
    }
    /**
     * Generate report of sales according to the enabled modules
     *
     * @param  Illuminate\Http\Request  $request
     * @param  App\models\company\Brunch $company
     * @param  \Carbon\Carbon  $from
     * @param  \Carbon\Carbon  $to
     * @param  bool  $dayStep
     * @param  bool  $weekStep
     * @param  bool  $monthStep
     * @param  bool  $yearStep
     *
     *  @return \Illuminate\Http\Response
     */
    private function generateReport(Brunch $company, Carbon $from, Carbon $to, $dayStep = false, $weekStep = false, $monthStep = false, $yearStep = false)
    {
        $from = $from->startOfDay();
        $defaultFrom = (new Carbon($from));
        $defaultTo = (new Carbon($to));

        $data = [];

        if ($company->hasFuncionality(SystemFuncionality::basic_sale())) {
            $tempFrom = (new Carbon($defaultFrom));
            $tempTo = (new Carbon($defaultTo));



            $currentTotal = 0;
            $values = [];

            for (;;) {
                if ($dayStep)
                    $end = ((new Carbon($tempFrom))->endOfDay());
                else if ($weekStep)
                    $end =  ((new Carbon($tempFrom))->endOfWeek());

                else if ($monthStep)
                    $end =   ((new Carbon($tempFrom))->endOfMonth());
                else if ($yearStep)
                    $end =  ((new Carbon($tempFrom))->endOfYear());
                else
                    throw new Exception("Step not defined");



                $partial = sumSales($company->basicSalesPeriod($tempFrom, $end)->get());
                array_push($values, $partial);
                $currentTotal = $currentTotal + $partial;

                if ($dayStep)
                    $tempFrom = ((new Carbon($tempFrom))->addDay());
                else if ($weekStep)
                    $tempFrom =  ((new Carbon($tempFrom))->addWeek());

                else if ($monthStep)
                    $tempFrom =   ((new Carbon($tempFrom))->addMonth());
                else if ($yearStep)
                    $tempFrom =  ((new Carbon($tempFrom))->addYear());

                if ($tempFrom->greaterThan($tempTo)) {
                    break;
                }
            }

            array_push($data, [
                'name' => 'BS',
                'values' => $values,
                'total' => $currentTotal
            ]);
        }

        if ($company->hasFuncionality(SystemFuncionality::cash_sale())) {
            $tempFrom = (new Carbon($defaultFrom));
            $tempTo = (new Carbon($defaultTo));




            $currentTotal = 0;
            $values = [];

            for (;;) {
                if ($dayStep)
                    $end = ((new Carbon($tempFrom))->endOfDay());
                else if ($weekStep)
                    $end =  ((new Carbon($tempFrom))->endOfWeek());

                else if ($monthStep)
                    $end =   ((new Carbon($tempFrom))->endOfMonth());
                else if ($yearStep)
                    $end =  ((new Carbon($tempFrom))->endOfYear());
                else
                    throw new Exception("Step not defined");



                $partial = sumSales($company->cashSalesPeriod($tempFrom, $end)->get());
                array_push($values, $partial);
                $currentTotal = $currentTotal + $partial;

                if ($dayStep)
                    $tempFrom = ((new Carbon($tempFrom))->addDay());
                else if ($weekStep)
                    $tempFrom =  ((new Carbon($tempFrom))->addWeek());

                else if ($monthStep)
                    $tempFrom =   ((new Carbon($tempFrom))->addMonth());
                else if ($yearStep)
                    $tempFrom =  ((new Carbon($tempFrom))->addYear());

                if ($tempFrom->greaterThan($tempTo)) {
                    break;
                }
            }

            array_push($data, [
                'name' => 'VD',
                'values' => $values,
                'total' => $currentTotal
            ]);
        }

        if ($company->hasFuncionality(SystemFuncionality::recipt())) {
            $tempFrom = (new Carbon($defaultFrom));
            $tempTo = (new Carbon($defaultTo));



            $currentTotal = 0;
            $values = [];

            for (;;) {
                if ($dayStep)
                    $end = ((new Carbon($tempFrom))->endOfDay());
                else if ($weekStep)
                    $end =  ((new Carbon($tempFrom))->endOfWeek());

                else if ($monthStep)
                    $end =   ((new Carbon($tempFrom))->endOfMonth());
                else if ($yearStep)
                    $end =  ((new Carbon($tempFrom))->endOfYear());
                else
                    throw new Exception("Step not defined");

                $partial = sumSales($company->receiptsPeriod($tempFrom, $end)->get());
                array_push($values, $partial);
                $currentTotal = $currentTotal + $partial;

                if ($dayStep)
                    $tempFrom = ((new Carbon($tempFrom))->addDay());
                else if ($weekStep)
                    $tempFrom =  ((new Carbon($tempFrom))->addWeek());

                else if ($monthStep)
                    $tempFrom =   ((new Carbon($tempFrom))->addMonth());
                else if ($yearStep)
                    $tempFrom =  ((new Carbon($tempFrom))->addYear());

                if ($tempFrom->greaterThan($tempTo)) {
                    break;
                }
            }

            array_push($data, [
                'name' => 'Recibos',
                'values' => $values,
                'total' => $currentTotal
            ]);
        }

        $tempFrom = (new Carbon($defaultFrom));
        $tempTo = (new Carbon($defaultTo));

        if ($dayStep)
            $keys = daysBetween($tempFrom, $tempTo);
        else if ($weekStep)
            $keys = weeksBetween($tempFrom, $tempTo);
        else if ($monthStep)
            $keys = monthsBetween($tempFrom, $tempTo);
        else if ($yearStep)
            $keys = yearsBetween($tempFrom, $tempTo);

        $tempFrom = (new Carbon($defaultFrom));
        $tempTo = (new Carbon($defaultTo));
        $total = $company->revenue($tempFrom, $tempTo);

        $ret =  [
            'reference' => [
                'from'  => $defaultFrom->format('d/m/Y'),
                'to'    => $defaultTo->format('d/m/Y')
            ],
            'total' => $total,
            'keys' =>  $keys,
            'data' => $data
        ];

        return response()->json($ret,  Response::HTTP_ACCEPTED);
    }
}
