<?php

namespace App\Http\Controllers\api\sales;

use App\models\sales\Basic;
use App\models\shifts\Shift;
use App\Http\Controllers\Controller;
use App\Http\Resources\sales\BasicResource;
use App\Http\Requests\sales\ReturnSaleRequest;
use Symfony\Component\HttpFoundation\Response;
use App\Http\Controllers\api\sales\BasicSaleController;

class ReturnSaleController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Basic $return)
    {
        return (new BasicSaleController())->show($return);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(ReturnSaleRequest $request, Basic $return)
    {
        $basic = $return;
        abort_if(!$basic->canBeChanged(), Response::HTTP_FORBIDDEN);

        if (!$request->user()->company->is($basic->company)) {
            abort_if(!$basic->canBeChanged(), Response::HTTP_FORBIDDEN);
        }

        if (!$request->user()->company->is($basic->company)) {
            abort_if(!$basic->canBeChanged(), Response::HTTP_FORBIDDEN);
        }

        $shift = $basic->company->shifts()->where(Shift::table() . '.id', $request->input('shift'))->first();
        if (!$shift) {
            abort(Response::HTTP_FORBIDDEN);
        }
        abort_if(!$shift->isOpen(), Response::HTTP_FORBIDDEN);


        $basic->saleItens->each(function ($item) {
            $item->quantity = 0 - $item->quantity;
            $item->save();
        });

        $basic->validate();
        $basic->shift()->associate($shift);
        $basic->save();
        return response()->json([
            'body' => new BasicResource($basic),
        ], Response::HTTP_ACCEPTED);
    }
}
