<?php

namespace App\Http\Controllers\api\sales\relation;

use App\models\sales\Basic;
use App\models\stock\Saleable;
use App\Http\Controllers\Controller;
use App\Http\Resources\sales\BasicResource;
use Symfony\Component\HttpFoundation\Response;
use App\models\sales\relation\ItemSalableBasic;
use App\Http\Requests\sales\relation\ItemSalableBasicRequest;


class ItemSalableBasicController extends Controller
{
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ItemSalableBasicRequest $request, Basic $basic)
    {

        $alerts =  [];



        abort_if(!$basic->canBeChanged(), Response::HTTP_FORBIDDEN);
        abort_if(!request()->user()->can('update', $basic), Response::HTTP_FORBIDDEN);

        $sale_code = $request->input('sale_code');
        $sale_name = $request->input('sale_name');
        $unit_amount = $request->input('unit_amount');
        $vat_tax = $request->input('vat_tax');
        $item =  new ItemSalableBasic();


        if ($request->filled('saleable')) {
            $saleable = Saleable::find($request->input('saleable'));

            $item = $basic->hasSaleItem($saleable);

            $item =  $item ? $item : new ItemSalableBasic();

            $item->saleable()->associate($saleable);

            $sale_code      = $sale_code ? $sale_code : $saleable->code;
            $sale_name      = $sale_name ? $sale_name : $saleable->name;
            $unit_amount    = $unit_amount ? $unit_amount : $saleable->price;
            $vat_tax        = $vat_tax ? $vat_tax : $saleable->vatScheme->tax;
        }
        $item->basic()->associate($basic);





        //verifcando o stock do produto;


        $entryQty = $request->input('quantity');




            $user = request()->user();

            $warehouse = $user->brunch->saleWarehouse();

            $move = $warehouse->lastMove($saleable);

            if ($move){
                if (($move->balance - $entryQty)  < 0) {
                    array_push($alerts, 'Quantidade fora do Stock'.'<br/> <br/> Balanço Actual:  &nbsp;'.number_format($move->balance));
                } else {
                    $item->sale_code = $sale_code;
                    $item->sale_name = $sale_name;
                    $item->quantity = $item->quantity + $request->input('quantity');
                    $item->unit_amount = $unit_amount;
                    $item->discount = $request->input('discount', 0);
                    $item->vat_tax = $vat_tax;
                    $item->save();
                }

            } else
                array_push($alerts, __('Não existem entradas no armazém'));





        return response()->json([
            'message' => 'yes',
            'alerts' => $alerts,
            'body' => new BasicResource($basic)
        ], Response::HTTP_CREATED);
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Basic $basic, ItemSalableBasic $item)
    {
        abort_if(!$basic->canBeChanged(), Response::HTTP_FORBIDDEN);
        abort_if(!$item->basic->is($basic), Response::HTTP_FORBIDDEN);
        abort_if(!request()->user()->can('update', $basic), Response::HTTP_FORBIDDEN);

        $item->forceDelete();
        return response()->json([
            'message' => 'OK',
        ], Response::HTTP_NO_CONTENT);
    }
}
