<?php

namespace App\Http\Controllers\api\sales\relation;

use App\models\sales\CashSale;
use App\models\stock\Saleable;
use App\Http\Controllers\Controller;
use App\Http\Resources\sales\CashSaleResource;
use Symfony\Component\HttpFoundation\Response;
use App\models\sales\relation\ItemSalableCashSale;
use App\Http\Requests\sales\relation\ItemSalableCashSaleRequest;
use Illuminate\Support\Facades\DB;


class ItemSalableCashSaleController extends Controller
{
    public function store(ItemSalableCashSaleRequest $request, CashSale $cashsale)
    {
        $alerts =  [];

        abort_if(!$cashsale->canBeChanged(), Response::HTTP_FORBIDDEN);
        abort_if(!request()->user()->can('update', $cashsale), Response::HTTP_FORBIDDEN);

        $sale_code = $request->input('sale_code');
        $sale_name = $request->input('sale_name');
        $unit_amount = $request->input('unit_amount');
        $vat_tax = $request->input('vat_tax');
        $item =  new ItemSalableCashSale();


        if ($request->filled('saleable')) {
            $saleable = Saleable::find($request->input('saleable'));

            $item = $cashsale->hasSaleItem($saleable);

            $item =  $item ? $item : new ItemSalableCashSale();

            $item->saleable()->associate($saleable);

            $sale_code      = $sale_code ? $sale_code : $saleable->code;
            $sale_name      = $sale_name ? $sale_name : $saleable->name;
            $unit_amount    = $unit_amount ? $unit_amount : $saleable->price;
            $vat_tax        = $vat_tax ? $vat_tax : $saleable->vatScheme->tax;
        }
        $item->cashsale()->associate($cashsale);


            //verifcando o stock do produto;

            $onSotck = DB::table('stock_moves')->where('saleable_id', $request->input('saleable'))->latest('created_at')->first();
            $entryQty = $request->input('quantity');

            if( ($onSotck->balance - $entryQty) < 0){
                array_push($alerts, 'Quantidade fora do Stock'.'<br/> <br/> Balanço Actual:  &nbsp;'.number_format($onSotck->balance));

             } else {

                $item->sale_code = $sale_code;
                $item->sale_name = $sale_name;
                $item->quantity = $item->quantity + $request->input('quantity');
                $item->unit_amount = $unit_amount;
                $item->discount = $request->input('discount', 0);
                $item->vat_tax = $vat_tax;

                $item->save();

             }


        return response()->json([
            'message' => 'OK',
            'alerts' => $alerts,
            'body' => new CashSaleResource($cashsale)
        ], Response::HTTP_CREATED);
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(CashSale $cashsale, ItemSalableCashSale $item)
    {
        abort_if(!$cashsale->canBeChanged(), Response::HTTP_FORBIDDEN);
        abort_if(!$item->cashsale->is($cashsale), Response::HTTP_FORBIDDEN);
        abort_if(!request()->user()->can('update', $cashsale), Response::HTTP_FORBIDDEN);

        $item->forceDelete();
        return response()->json([
            'message' => 'OK',
        ], Response::HTTP_NO_CONTENT);
    }
}
