<?php

namespace App\Http\Controllers\api\sales\relation;

use App\models\stock\Saleable;
use App\models\sales\CreditNote;
use App\Http\Controllers\Controller;
use Symfony\Component\HttpFoundation\Response;
use App\Http\Resources\sales\CreditNoteResource;
use App\models\sales\relation\ItemSalableCreditNote;
use App\Http\Requests\sales\relation\ItemSalableCreditNoteRequest;


class ItemSalableCreditNoteController extends Controller
{
    public function store(ItemSalableCreditNoteRequest $request, CreditNote $creditnote)
    {
        abort_if(!$creditnote->canBeChanged(), Response::HTTP_FORBIDDEN);
        abort_if(!request()->user()->can('update', $creditnote), Response::HTTP_FORBIDDEN);

        $sale_code = $request->input('sale_code');
        $sale_name = $request->input('sale_name');
        $unit_amount = $request->input('unit_amount');
        $vat_tax = $request->input('vat_tax');
        $item =  new ItemSalableCreditNote();

        if ($request->filled('saleable')) {
            $saleable = Saleable::find($request->input('saleable'));

            $item = $creditnote->hasSaleItem($saleable);

            $item =  $item ? $item : new ItemSalableCreditNote();

            $item->saleable()->associate($saleable);

            $sale_code      = $sale_code ? $sale_code : $saleable->code;
            $sale_name      = $sale_name ? $sale_name : $saleable->name;
            $unit_amount    = $unit_amount ? $unit_amount : $saleable->price;
            $vat_tax        = $vat_tax ? $vat_tax : $saleable->vatScheme->tax;
        }
        $item->creditnote()->associate($creditnote);


        $item->sale_code = $sale_code;
        $item->sale_name = $sale_name;
        $item->quantity = $item->quantity + $request->input('quantity');
        $item->unit_amount = $unit_amount;
        $item->discount = $request->input('discount', 0);
        $item->vat_tax = $vat_tax;

        $item->save();
        return response()->json([
            'message' => 'OK',
            'body' => new CreditNoteResource($creditnote)
        ], Response::HTTP_CREATED);
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(CreditNote $creditnote, ItemSalableCreditNote $item)
    {
        abort_if(!$creditnote->canBeChanged(), Response::HTTP_FORBIDDEN);
        abort_if(!$item->creditnote->is($creditnote), Response::HTTP_FORBIDDEN);
        abort_if(!request()->user()->can('update', $creditnote), Response::HTTP_FORBIDDEN);

        $item->forceDelete();
        return response()->json([
            'message' => 'OK',
        ], Response::HTTP_NO_CONTENT);
    }
}
