<?php

namespace App\Http\Controllers\api\sales\relation;

use App\models\stock\Saleable;
use App\models\sales\DebitNote;
use App\Http\Controllers\Controller;
use Symfony\Component\HttpFoundation\Response;
use App\Http\Resources\sales\DebitNoteResource;
use App\models\sales\relation\ItemSalableDebitNote;
use App\Http\Requests\sales\relation\ItemSalableDebitNoteRequest;

class ItemSalableDebitNoteController extends Controller
{
    public function store(ItemSalableDebitNoteRequest $request, DebitNote $debitnote)
    {
        abort_if(!$debitnote->canBeChanged(), Response::HTTP_FORBIDDEN);
        abort_if(!request()->user()->can('update', $debitnote), Response::HTTP_FORBIDDEN);

        $sale_code = $request->input('sale_code');
        $sale_name = $request->input('sale_name');
        $unit_amount = $request->input('unit_amount');
        $vat_tax = $request->input('vat_tax');
        $item =  new ItemSalableDebitNote();

        if ($request->filled('saleable')) {
            $saleable = Saleable::find($request->input('saleable'));

            $item = $debitnote->hasSaleItem($saleable);

            $item =  $item ? $item : new ItemSalableDebitNote();

            $item->saleable()->associate($saleable);

            $sale_code      = $sale_code ? $sale_code : $saleable->code;
            $sale_name      = $sale_name ? $sale_name : $saleable->name;
            $unit_amount    = $unit_amount ? $unit_amount : $saleable->price;
            $vat_tax        = $vat_tax ? $vat_tax : $saleable->vatScheme->tax;
        }
        $item->debitnote()->associate($debitnote);


        $item->sale_code = $sale_code;
        $item->sale_name = $sale_name;
        $item->quantity = $item->quantity + $request->input('quantity');
        $item->unit_amount = $unit_amount;
        $item->discount = $request->input('discount', 0);
        $item->vat_tax = $vat_tax;

        $item->save();
        return response()->json([
            'message' => 'OK',
            'body' => new DebitNoteResource($debitnote)
        ], Response::HTTP_CREATED);
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(DebitNote $debitnote, ItemSalableDebitNote $item)
    {
        abort_if(!$debitnote->canBeChanged(), Response::HTTP_FORBIDDEN);
        abort_if(!$item->debitnote->is($debitnote), Response::HTTP_FORBIDDEN);
        abort_if(!request()->user()->can('update', $debitnote), Response::HTTP_FORBIDDEN);

        $item->forceDelete();
        return response()->json([
            'message' => 'OK',
        ], Response::HTTP_NO_CONTENT);
    }
}
