<?php

namespace App\Http\Controllers\api\sales\relation;

use App\models\sales\Proforma;
use App\models\stock\Saleable;
use App\Http\Controllers\Controller;
use App\Http\Resources\sales\ProformaResource;
use Symfony\Component\HttpFoundation\Response;
use App\models\sales\relation\ItemSalableProforma;
use App\Http\Requests\sales\relation\ItemSalableProformaRequest;

class ItemSalableProformaController extends Controller
{
    public function store(ItemSalableProformaRequest $request, Proforma $proforma)
    {
        abort_if(!$proforma->canBeChanged(), Response::HTTP_FORBIDDEN);
        abort_if(!request()->user()->can('update', $proforma), Response::HTTP_FORBIDDEN);

        $sale_code = $request->input('sale_code');
        $sale_name = $request->input('sale_name');
        $unit_amount = $request->input('unit_amount');
        $vat_tax = $request->input('vat_tax');
        $item =  new ItemSalableProforma();


        if ($request->filled('saleable')) {
            $saleable = Saleable::find($request->input('saleable'));

            $item = $proforma->hasSaleItem($saleable);

            $item =  $item ? $item : new ItemSalableProforma();

            $item->saleable()->associate($saleable);

            $sale_code      = $sale_code ? $sale_code : $saleable->code;
            $sale_name      = $sale_name ? $sale_name : $saleable->name;
            $unit_amount    = $unit_amount ? $unit_amount : $saleable->price;
            $vat_tax        = $vat_tax ? $vat_tax : $saleable->vatScheme->tax;
        }
        $item->proforma()->associate($proforma);


        $item->sale_code = $sale_code;
        $item->sale_name = $sale_name;
        $item->quantity = $item->quantity + $request->input('quantity');
        $item->unit_amount = $unit_amount;
        $item->discount = $request->input('discount', 0);
        $item->vat_tax = $vat_tax;

        $item->save();
        return response()->json([
            'message' => 'OK',
            'body' => new ProformaResource($proforma)
        ], Response::HTTP_CREATED);
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Proforma $proforma, ItemSalableProforma $item)
    {
        abort_if(!$proforma->canBeChanged(), Response::HTTP_FORBIDDEN);
        abort_if(!$item->proforma->is($proforma), Response::HTTP_FORBIDDEN);
        abort_if(!request()->user()->can('update', $proforma), Response::HTTP_FORBIDDEN);

        $item->forceDelete();
        return response()->json([
            'message' => 'OK',
        ], Response::HTTP_NO_CONTENT);
    }
}
