<?php
namespace App\Http\Controllers\api\sales\utils;




trait CanCopyDocument
{
    public function copyDocument($document, $target, $targetIntermediateClass)
    {
        $target->financial_discount = $document->financial_discount;
        $target->obs = $document->obs;
        $target->save();


        

        $document->saleItens->each(function ($saleItem) use ($target, $targetIntermediateClass) {
            $item = $saleItem->saleable ? $target->hasSaleItem($saleItem->saleable) : null;
            $item =  $item ? $item : new $targetIntermediateClass();
            $item->intermediate()->associate($target);
            $item->saleable()->associate($saleItem->saleable);

            $item->sale_code    = $saleItem->sale_code;
            $item->sale_name    = $saleItem->sale_name;
            $item->quantity     = $item->quantity + $saleItem->quantity;
            $item->unit_amount  = $saleItem->unit_amount;
            $item->discount     = $saleItem->discount;
            $item->vat_tax      = $saleItem->vat_tax;


            $item->save();
        });

        return $target;
    }
}
