<?php

namespace App\Http\Controllers\api\shifts;

use App\models\shifts\Shift;
use App\Http\Controllers\Controller;
use App\Http\Requests\shifts\ShiftRequest;
use Symfony\Component\HttpFoundation\Response;

class ShiftController extends Controller
{
    public function update(ShiftRequest $request, Shift $shift)
    {
        if ($shift->isOpen()) {
            $shift->close(request()->user());
        }

        return response()->json([
            'message' => 'OK',
        ], Response::HTTP_ACCEPTED);
    }
}
