<?php

namespace App\Http\Controllers\api\stock;

use App\models\stock\Category;
use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;
use App\Http\Requests\stock\CategoryRequest;
use Symfony\Component\HttpFoundation\Response;

class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(CategoryRequest $request)
    {
        $category = new Category();
        $category->name = $request->input('name');
        $category->description = $request->input('description');
        $category->company()->associate($request->user()->company);

        $category->save();
        return response()->json([
            'message' => 'OK',
            'url' => [
                'web' => URL::route('web.stock.category.show', ['category' => $category->id])
            ]
        ], Response::HTTP_CREATED);
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(CategoryRequest $request, Category $category)
    {
        abort_if(!request()->user()->can('update', $category), Response::HTTP_FORBIDDEN);

        $category->name = $request->input('name');
        $category->description = $request->input('description');

        $category->save();
        return response()->json([
            'message' => 'OK',
            'url' => [
                'web' => URL::route('web.stock.category.show', ['category' => $category->id])
            ]
        ], Response::HTTP_ACCEPTED);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Category $category)
    {
        abort_if(!request()->user()->can('delete', $category), Response::HTTP_FORBIDDEN);

        $category->forceDelete();

        return response()->json([
            'message' => 'OK',
        ], Response::HTTP_NO_CONTENT);
    }
}
