<?php

namespace App\Http\Controllers\api\stock;

use App\models\stock\Provider;
use App\models\customers\Customer;
use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;
use App\Http\Requests\stock\ProviderRequest;
use Symfony\Component\HttpFoundation\Response;

class ProviderController extends Controller
{
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ProviderRequest $request)
    {
        $provider = new Provider();
        $provider->name = $request->input('name');
        $provider->contact = $request->input('contact');
        $provider->address = $request->input('address');
        $provider->responsible = $request->input('responsible');
        $provider->company()->associate($request->user()->company);

        if ($request->filled('customer')) {
            $customer = Customer::find($request->input('customer'));
            abort_if(!request()->user()->can('update', $customer), Response::HTTP_FORBIDDEN);
            $provider->customer()->associate($customer);
        }
        $provider->save();


        return response()->json([
            'message' => 'OK',
            'url' => [
                'web' => URL::route('web.stock.providers.show', ['provider' => $provider->id])
            ]
        ], Response::HTTP_CREATED);

    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(ProviderRequest $request, Provider $provider)
    {
        abort_if(!request()->user()->can('update', $provider), Response::HTTP_FORBIDDEN);

        $provider->name = $request->input('name');
        $provider->contact = $request->input('contact');
        $provider->address = $request->input('address');
        $provider->responsible = $request->input('responsible');

        if ($request->filled('customer')) {
            $customer = Customer::find($request->input('customer'));
            abort_if(!request()->user()->can('update', $customer), Response::HTTP_FORBIDDEN);
            $provider->customer()->associate($customer);
        }

        $provider->save();



        return response()->json([
            'message' => 'OK',
            'url' => [
                'web' => URL::route('web.stock.providers.show', ['provider' => $provider->id])
            ]
        ], Response::HTTP_ACCEPTED);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy( Provider $provider)
    {
        abort_if(!request()->user()->can('delete', $provider), Response::HTTP_FORBIDDEN);

        $provider->forceDelete();

        return response()->json([
            'message' => 'OK',
        ], Response::HTTP_NO_CONTENT);
    }
}
