<?php

namespace App\Http\Controllers\api\stock;

use App\models\stock\SaleUnit;
use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;
use App\Http\Requests\stock\SaleUnitRequest;
use Symfony\Component\HttpFoundation\Response;

class SaleUnitController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(SaleUnitRequest $request)
    {
        $unit = new SaleUnit();
        $unit->name = $request->input('name');
        $unit->abbr = $request->input('abbr');
        $unit->company()->associate($request->user()->company);
        $unit->save();

        return response()->json([
            'message' => 'OK',
            'url' => [
                'web' => URL::route('web.stock.saleunit.show', ['saleunit' => $unit->id])
            ]
        ], Response::HTTP_CREATED);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    public function update(SaleUnitRequest $request, SaleUnit $saleunit)
    {
        abort_if(!request()->user()->can('update', $saleunit), Response::HTTP_FORBIDDEN);

        $saleunit->name = $request->input('name');
        $saleunit->abbr = $request->input('abbr');
        $saleunit->save();

        return response()->json([
            'message' => 'OK',
            'url' => [
                'web' => URL::route('web.stock.saleunit.show', ['saleunit' => $saleunit->id])
            ]
        ], Response::HTTP_ACCEPTED);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy( SaleUnit $saleunit)
    {
        abort_if(!request()->user()->can('delete', $saleunit), Response::HTTP_FORBIDDEN);

        $saleunit->forceDelete();

        return response()->json([
            'message' => 'OK',
        ], Response::HTTP_NO_CONTENT);
    }
}
