<?php

namespace App\Http\Controllers\api\stock;

use App\models\stock\Warehouse;
use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;
use App\Http\Requests\stock\WarehouseRequest;
use Symfony\Component\HttpFoundation\Response;

class WarehouseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(WarehouseRequest $request)
    {
        //

        $company = $request->user()->company;
        $alter = $request->input('selling', false) ? true : false;
        if ($alter)
            $company->warehouses()->update(['selling_werehouse' => false]);

        $warehouse = new Warehouse();
        $warehouse->name = $request->input('name');
        $warehouse->contact = $request->input('contact');
        $warehouse->address = $request->input('address');
        $warehouse->responsible = $request->input('responsible');
        $warehouse->selling_werehouse = $alter;
        $warehouse->company()->associate($company);
        $warehouse->save();



        return response()->json([
            'message' => 'OK',
            'url' => [
                'web' => URL::route('web.stock.warehouse.show', ['warehouse' => $warehouse->id])
            ]
        ], Response::HTTP_CREATED);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(WarehouseRequest $request, Warehouse  $warehouse)
    {
        abort_if(!request()->user()->can('update', $warehouse), Response::HTTP_FORBIDDEN);

        $company = $warehouse->company;
        $alter = $request->input('selling', false) ? true : false;
       
        if ($alter)
            $company->warehouses()->update(['selling_werehouse' => false]);


        $warehouse->name = $request->input('name');
        $warehouse->contact = $request->input('contact');
        $warehouse->address = $request->input('address');
        $warehouse->responsible = $request->input('responsible');
        $warehouse->selling_werehouse = $alter;
        $warehouse->save();

        return response()->json([
            'message' => 'OK',
            'url' => [
                'web' => URL::route('web.stock.warehouse.show', ['warehouse' => $warehouse->id])
            ]
        ], Response::HTTP_ACCEPTED);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Warehouse $warehouse)
    {
        abort_if(!request()->user()->can('delete', $warehouse), Response::HTTP_FORBIDDEN);

        $warehouse->forceDelete();
        return response()->json([
            'message' => 'OK',
        ], Response::HTTP_NO_CONTENT);
    }
}
