<?php

namespace App\Http\Controllers\api\stock\transference;

use App\models\stock\Saleable;
use App\models\stock\StockMove;
use App\models\stock\Warehouse;
use App\Http\Controllers\Controller;
use Symfony\Component\HttpFoundation\Response;
use App\models\stock\transference\StockTransference;
use App\models\stock\transference\StockTransferenceGroup;
use App\Http\Requests\stock\transference\TransferenceRequest;

class TransferenceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(TransferenceRequest $request, StockTransferenceGroup $group)
    {
        abort_if(!request()->user()->is($group->user), Response::HTTP_FORBIDDEN);
        abort_if($group->isValid(), Response::HTTP_FORBIDDEN);

        $saleable       = Saleable::find($request->input('saleable'));
        $warehouseFrom  = Warehouse::find($request->input('warehouse_from'));
        $warehouseTo    = Warehouse::find($request->input('warehouse_to'));
        $quantity       = $request->input('quantity');

        if (!$saleable->company->is($request->user()->company)) {
            abort(Response::HTTP_FORBIDDEN);
        }

        if (!$warehouseFrom->company->is($request->user()->company)) {
            abort(Response::HTTP_FORBIDDEN);
        }

        if (!$warehouseTo->company->is($request->user()->company)) {
            abort(Response::HTTP_FORBIDDEN);
        }

        $user = request()->user();
        $stockMoveTo    = StockMove::transfer($saleable, $warehouseTo, $user,  $quantity);



        $stockMoveFrom  = StockMove::transfer($saleable, $warehouseFrom, $user,  0 - $quantity);

        $transfer = new StockTransference();
        $transfer->stockMoveTo()->associate($stockMoveTo);;
        $transfer->stockMoveFrom()->associate($stockMoveFrom);;
        $transfer->group()->associate($group);
        $transfer->save();

        return response()->json([], Response::HTTP_CREATED);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(StockTransferenceGroup $group, StockTransference $transfer)
    {
        abort_if(!request()->user()->is($group->user), Response::HTTP_FORBIDDEN);
        abort_if($group->isValid(), Response::HTTP_FORBIDDEN);
        $transfer->forceDelete();
        return response()->json([], Response::HTTP_NO_CONTENT);
    }
}
