<?php

namespace App\Http\Controllers\api\stock\transference;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Symfony\Component\HttpFoundation\Response;
use App\models\stock\transference\StockTransference;
use App\models\stock\transference\StockTransferenceGroup;
use App\Http\Resources\stock\transference\TransferGroupResource;

class TransferenceGroupController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(StockTransferenceGroup $group)
    {
        return new TransferGroupResource($group);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    public function cancel(StockTransferenceGroup $group)
    {
        abort_if(!request()->user()->is($group->user), Response::HTTP_FORBIDDEN);
        abort_if($group->isValid(), Response::HTTP_FORBIDDEN);
        $group->forceDelete();
        return response()->json([
            'message' => 'OK',
        ], Response::HTTP_NO_CONTENT);
    }

    public function finalize(StockTransferenceGroup $group)
    {
        abort_if(!request()->user()->is($group->user), Response::HTTP_FORBIDDEN);
        abort_if($group->isValid(), Response::HTTP_FORBIDDEN);
        $group->transfers->each(function(StockTransference $item){
            $item->stockMoveFrom->validate();
            $item->stockMoveTo->validate();
        });
        $group->validated_at = now();
        $group->save();
        return response()->json([
            'message' => 'OK',
        ], Response::HTTP_ACCEPTED);
    }
}
