<?php

namespace App\Http\Controllers\api\users;

use App\models\users\Role;
use App\models\users\User;
use App\models\company\Brunch;
use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Hash;
use App\Http\Requests\users\UserRequest;
use Symfony\Component\HttpFoundation\Response;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(UserRequest $request, Brunch $brunch)
    {
        $allow = false;
        $allow = Gate::allows('manage-users', $brunch);
        abort_if(!$allow, Response::HTTP_FORBIDDEN);

        $user = new User();

        $user->name = $request->input('name');
        $user->email = $request->input('email');
        $user->invisible = 0;
        $user->password = Hash::make(1234567890);
        $user->company()->associate($brunch);
        $user->save();
        return response()->json([
            'message' => 'OK',
            'url' => [
                'web' => URL::route('web.company.brunch.users.show', ['brunch' => $brunch->id, 'user' => $user->id])
            ]
        ], Response::HTTP_CREATED);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UserRequest $request, Brunch $brunch, User $user)
    {
        //
        $allow = false;
        $allow = Gate::allows('manage-users', $brunch);
        $allow = ($allow and $user->can('work-in', $brunch));
        abort_if(!$allow, Response::HTTP_FORBIDDEN);

        if ($request->filled('roles')) {
            $roles = $brunch->roles()->whereIn(Role::table() . '.id', $request->input('roles'))->get();
            $user->roles()->sync($roles->pluck('id'));
        } else if ($request->filled('name')) {
            $user->name = $request->input('name');
            $user->email = $request->input('email');
        } else {
            $user->password = Hash::make($request->input('password'));
        }
        $user->save();

        return response()->json([
            'message' => 'OK',
            'url' => [
                'web' => URL::route('web.company.brunch.users.show', ['brunch' => $brunch->id, 'user' => $user->id])
            ]
        ], Response::HTTP_ACCEPTED);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
