<?php

namespace App\Http\Controllers\web\company;

use App\models\company\Brunch;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Gate;
use App\models\company\CompanyVatScheme;
use App\models\company\SystemFuncionality;
use Symfony\Component\HttpFoundation\Response;

class BrunchController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        abort_if(Gate::denies('manage-global'), Response::HTTP_FORBIDDEN);
        $companies = Brunch::all();
        $data = compact('companies');
        return view('company.brunch.list.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        abort_if(Gate::denies('manage-global'), Response::HTTP_FORBIDDEN);
        $funcionalities = SystemFuncionality::all();
        $vatschemes = CompanyVatScheme::all();
        $data = compact('funcionalities', 'vatschemes');
        return view('company.brunch.create.index', $data);
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Brunch $brunch)
    {
        abort_if(Gate::denies('manage-brunch', $brunch) , Response::HTTP_FORBIDDEN);
        $funcionalities = SystemFuncionality::all();
        $vatschemes = CompanyVatScheme::all();
        $data = compact('brunch','funcionalities', 'vatschemes');
        return view('company.brunch.show.index', $data);
    }
}
