<?php

namespace App\Http\Controllers\web\company;

use App\models\company\Brunch;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Gate;
use Symfony\Component\HttpFoundation\Response;

class CompanyHomeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Brunch $brunch)
    {
        abort_if(Gate::denies('manage-brunch', $brunch), Response::HTTP_FORBIDDEN);
        $sale_config = $brunch->basicSaleOption;
        $crm_config = $brunch->crmConfig;

        $data = compact(
            'brunch',
            'sale_config',
            'crm_config'
        );
        return view('company.config.index', $data);
    }
}
