<?php

namespace App\Http\Controllers\web\customers;

use App\models\customers\Customer;
use App\Http\Controllers\Controller;
use App\models\sales\CreditNote;
use Symfony\Component\HttpFoundation\Response;

class CustomerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $brunch = request()->user()->company;
        $customers = $brunch->customers;
        $data = compact(
            'customers'
        );
        return view('customers.customer.list.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('customers.customer.create.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Customer $customer)
    {
        abort_if(!request()->user()->can('view', $customer), Response::HTTP_FORBIDDEN);
        $data = compact(
            'customer'
        );
        return view('customers.customer.show.index', $data);
    }

    public function statement(Customer $customer)
    {
        abort_if(!request()->user()->can('view', $customer), Response::HTTP_FORBIDDEN);
        $data = compact(
            'customer'
        );

        return view('customers.customer.statement.index', $data);
    }
}
