<?php

namespace App\Http\Controllers\web\customers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\CustomerStatamentRequest;
use App\models\customers\Customer;
use Barryvdh\Snappy\Facades\SnappyPdf;
use Barryvdh\DomPDF\Facade\Pdf;
use Doctrine\DBAL\Types\FloatType;

class CustomerOperationController extends Controller
{
     public function print(Request $request){



         $operations = collect([]);

         foreach($request->all as $item){
            $operations->push((object)$item);
         }

         $total = $request->total ; // total de valor
         $paidamount = $request->paidamount; // total pago
         $pendingamount = $request->pendingamount; //valor pendente






         $from = $request->from_default;
         $to   =$request->to_default;
         $company = request()->user()->company;
         $customer = Customer::find($request->customer);
         $type = $request->type;





         $data = compact('operations', 'from', 'to', 'company', 'customer', 'type', 'total', 'paidamount', 'pendingamount');

        //  ->setPaper('a4', 'landscape')

         $pdf = Pdf::loadView('reports.customer.index', $data)->setPaper('a4', 'landscape');

         return $pdf->download($company->name.'-'.$customer->name.'-report-'.$type.'.'.'pdf');
     }
}
