<?php

namespace App\Http\Controllers\web\provider;


use Illuminate\Http\Request;
use App\models\stock\Provider;
use App\models\provider\Expense;
use App\Http\Controllers\Controller;
use Symfony\Component\HttpFoundation\Response;

class ExpensesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Provider $provider)
    {
        abort_if(!request()->user()->can('view', $provider), Response::HTTP_FORBIDDEN);
        $expenses = $provider->expenses()->whereMonth(Expense::table() . '.created_at', now()->month)
            ->whereYear(Expense::table() . '.created_at', now()->year)
            ->get();
        $data = compact('provider', 'expenses');
        return view('stock.provider.expenses.list.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Provider $provider)
    {
        abort_if(!request()->user()->can('update', $provider), Response::HTTP_FORBIDDEN);
        $data = compact('provider');
        return view('stock.provider.expenses.create.index', $data);
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Provider $provider, Expense $expense)
    {
        abort_if(!request()->user()->can('update', $provider), Response::HTTP_FORBIDDEN);
        $data = compact('provider', 'expense');
        return view('stock.provider.expenses.show.index', $data);
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
