<?php
namespace App\Http\Controllers\web\provider;


use Carbon\Carbon;
use App\models\stock\Provider;
use App\Http\Controllers\Controller;
use Symfony\Component\HttpFoundation\Response;
use App\Http\Requests\customers\CustomerOperationRequest;

class ProviderOperationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Provider $provider, CustomerOperationRequest $request)
    {
        abort_if(!request()->user()->can('view', $provider), Response::HTTP_FORBIDDEN);

        $query =  $provider->providerOperations();

        if ($request->filled('from')) {
            $from   = (new Carbon($request->input('from')))->startOfDay();
            $query = $query->whereDate('validated_at', '>=', $from);
        }

        if ($request->filled('to')) {
            $to     = (new Carbon($request->input('to')))->endOfDay();
            $query = $query->whereDate('validated_at', '<=', $to);
        }

        $take   = $request->input('take', 20);
        $operations = $query->orderBy('id', 'DESC')
            ->take($take)->get()
            ->sortBy('id');

        $data = compact('operations', 'provider');
        return view('stock.provider.statement.index', $data);
    }
}
