<?php

namespace App\Http\Controllers\web\provider;

use Illuminate\Http\Request;
use App\models\stock\Provider;
use App\models\provider\Purchase;
use App\Http\Controllers\Controller;
use Symfony\Component\HttpFoundation\Response;

class PurchaseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Provider $provider)
    {
        abort_if(!request()->user()->can('update', $provider), Response::HTTP_FORBIDDEN);

        $purchase = $provider->unfinishedPurchase();
        $brunch = request()->user()->company;
        $saleables = $brunch->saleables;
        $warehouses = $brunch->warehouses;

        $data = compact('provider', 'purchase', 'saleables', 'warehouses');

        return view('stock.provider.purchases.create.index', $data);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Provider $provider, Purchase $purchase)
    {
        abort_if(!$provider->is($purchase->provider), Response::HTTP_NOT_FOUND);
        abort_if(!request()->user()->can('view', $provider), Response::HTTP_FORBIDDEN);
        abort_if(!request()->user()->can('view', $purchase), Response::HTTP_FORBIDDEN);

        $purchase->load('stockMoves.saleable');
        $data = compact('provider', 'purchase');

        return view('stock.provider.purchases.show.index', $data);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
