<?php

namespace App\Http\Controllers\web\sales;

use App\models\sales\Basic;
use App\Http\Controllers\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Flasher\Toastr\Prime\ToastrFactory;
use Illuminate\Support\Facades\DB;

class BasicSaleController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        return $this->report(request());

        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user = request()->user();
        $brunch = $user->company;
        $basic = $user->createBasicSale();
        $saleables = $brunch->saleables()->with('vatScheme')->get();
        $customers = $brunch->customers;

        $crm = false;
        if ($brunch->crmConfig) {
            if ($user->can('funcionality-crm', $brunch))
                $crm =  $brunch->crmConfig ? $brunch->crmConfig->isEnabled() : false;
        }

        $data = compact(
            'customers',
            'saleables',
            'basic',
            'crm'
        );

        $fast = $brunch->basicSaleOption()->exists();
        if ($fast) {
            $fast = $brunch->basicSaleOption->fast_sale;
            if ($fast) {
                return view('sales.basic.create.fast.index', $data);
            }
        }

        return view('sales.basic.create.normal.index', $data);
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Basic $basic)
    {
        abort_if(!request()->user()->can('view', $basic), Response::HTTP_FORBIDDEN);
        $data = compact(
            'basic'
        );
        return view('sales.basic.show.index', $data);
    }

    public function print(Basic $basic)
    {
        $data = compact(
            'basic'
        );
        return view('sales.basic.print.index', $data);
    }




    public function report(Request $request)
    {
        $company = request()->user()->company;
        $data = compact('company');
        return view('reports.basicsales.index', $data);
    }

    public function cancel(Basic $basic, ToastrFactory $flasher){

        $items = $basic->saleItens;

        foreach( $items as $item){

              //verifcando o stock do produto;

            $onSotck = DB::table('stock_moves')->where('saleable_id', $item->saleable_id)->latest('created_at')->first();

            $update = DB::table('stock_moves')->where('saleable_id', $item->saleable_id)
            ->latest('created_at')->update([
                'balance' =>$onSotck->balance + $item->quantity
            ]);


            $item->delete();
        }

        $basic->delete();



        $flasher->addSuccess('Canceled');
        return redirect()->signedRoute('web.sales.basic.report');
     }
}
