<?php

namespace App\Http\Controllers\web\sales;

use Illuminate\Http\Request;
use App\models\sales\CashSale;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\models\sales\utils\PaymentMethod;
use Symfony\Component\HttpFoundation\Response;

class CashSaleController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return $this->report(request());


        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user = request()->user();
        $brunch = $user->company;
        $cashsale = $user->createCashSale();
        $saleables = $brunch->saleables()->with('vatScheme')->get();
        $customers = $brunch->customers;
        $paymentMethods = PaymentMethod::where(
            [
                ['id', '<>', PaymentMethod::crmpoints()->id],
                ['id', '<>', PaymentMethod::systemadvance()->id]
            ]
        )->get();

        $data = compact(
            'customers',
            'saleables',
            'cashsale',
            'paymentMethods'
        );
        return view('sales.cashsale.create.index', $data);
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(CashSale $cashsale)
    {
        abort_if(!request()->user()->can('view', $cashsale), Response::HTTP_FORBIDDEN);
        $data = compact(
            'cashsale'
        );
        return view('sales.cashsale.show.index', $data);
    }

    public function print(CashSale $cashsale)
    {
        $data = compact(
            'cashsale'
        );
        return view('sales.cashsale.print.invoice', $data);
    }

    public function pdf(CashSale $cashsale)
    {
        $data = compact(
            'cashsale'
        );
        return SnappyPdf::loadView('sales.cashsale.pdf.invoice', $data)->inline('cashsale.pdf');
    }



    public function report(Request $request)
    {
        $company = request()->user()->company;

        $data = compact('company');

        return view('reports.cashsales.index', $data);
    }
}
