<?php

namespace App\Http\Controllers\web\sales;

use Illuminate\Http\Request;
use App\models\sales\CreditNote;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use Symfony\Component\HttpFoundation\Response;

class CreditNoteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user = request()->user();
        $brunch = $user->company;
        $creditnote = $user->createCreditNote();
        $saleables  = $brunch->saleables()->with('vatScheme')->get();

        $customers = $brunch->customers()->has('invoices')->with('invoices')->get();
        $data = compact(
            'customers',
            'saleables',
            'creditnote'
        );
        return view('sales.creditnote.create.index', $data);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(CreditNote $creditnote)
    {
        $data = compact(
            'creditnote'
        );
        return view('sales.creditnote.show.index', $data);
    }

    public function pdf(CreditNote $creditnote)
    {
        $data = compact(
            'creditnote'
        );
        return SnappyPdf::loadView('sales.creditnote.pdf.creditnote', $data)->inline('creditnote.pdf');
    }

    public function print(CreditNote $creditnote)
    {
        $data = compact(
            'creditnote'
        );
        return view('sales.creditnote.print.creditnote', $data);
    }

    public function report(Request $request)
    {
        $company = request()->user()->company;

        $data = compact('company');

        return view('reports.creditnotes.index', $data);
    }
}
