<?php

namespace App\Http\Controllers\web\sales;

use Illuminate\Http\Request;
use App\models\sales\DebitNote;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;

class DebitNoteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user = request()->user();
        $brunch = $user->company;
        $debitnote = $user->createDebitNote();
        $saleables  = $brunch->saleables()->with('vatScheme')->get();

        $customers = $brunch->customers()->has('invoices')->with('invoices')->get();
        $data = compact(
            'customers',
            'saleables',
            'debitnote'
        );
        return view('sales.debitnote.create.index', $data);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(DebitNote $debitnote)
    {
        $data = compact(
            'debitnote'
        );
        return view('sales.debitnote.show.index', $data);
    }

    public function pdf(DebitNote $debitnote)
    {
        $data = compact(
            'debitnote'
        );
        return SnappyPdf::loadView('sales.debitnote.pdf.debitnote', $data)->inline('debitnote.pdf');
    }

    public function print(DebitNote $debitnote)
    {
        $data = compact(
            'debitnote'
        );
        return view('sales.debitnote.print.debitnote', $data);
    }



    public function report(Request $request)
    {
        $company = request()->user()->company;

        $data = compact('company');

        return view('reports.debitnotes.index', $data);
    }
}
