<?php

namespace App\Http\Controllers\web\sales;

use Illuminate\Http\Request;
use App\models\sales\DeliveryNote;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use Flasher\Toastr\Prime\ToastrFactory;
use Illuminate\Support\Facades\DB;

class DeliveryNoteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return $this->report(request());
        return view('sales.delivery_note.list.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user = request()->user();
        $brunch = $user->company;
        $delivery_note = $user->createDeliveryNote();
        $saleables = $brunch->saleables()->with('vatScheme')->get();
        $warehouses = $brunch->warehouses;

        $customers = $brunch->customers()
            ->where('default', false)
            ->orWhere('default', 0)
            ->orWhere('default', null)
            ->get();

        $data = compact(
            'warehouses',
            'customers',
            'saleables',
            'delivery_note'
        );
        return view('sales.delivery_note.create.index', $data);
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(DeliveryNote $deliveryNote)
    {
        $data = compact(
            'deliveryNote'
        );
        return view('sales.delivery_note.show.index', $data);
    }

    public function pdf(DeliveryNote $deliveryNote)
    {
        $data = compact(
            'deliveryNote'
        );

        // return         view('sales.delivery_note.pdf.delivery_note', $data);
        return SnappyPdf::loadView('sales.delivery_note.pdf.delivery_note', $data)->inline('delivery_note.pdf');
    }

    public function print(Deliverynote $deliveryNote)
    {
        $data = compact(
            'deliveryNote'
        );
        return view('sales.delivery_note.print.delivery_note', $data);
    }

    public function report(Request $request)
    {
        $company = request()->user()->company;

        $data = compact('company');

        return view('reports.delivery_notes.index', $data);
    }

    public function cancel(Deliverynote $deliveryNote, ToastrFactory $flasher){

        $items = $deliveryNote->saleItens;

        if ($deliveryNote->invoiced == 1) {
            $flasher->addError('Desculpa Guia ja faturada');
            return back();
        }

        foreach( $items as $item){

              //verifcando o stock do produto;

            $onSotck = DB::table('stock_moves')->where('saleable_id', $item->saleable_id)->latest('created_at')->first();

            $update = DB::table('stock_moves')->where('saleable_id', $item->saleable_id)
            ->latest('created_at')->update([
                'balance' =>$onSotck->balance + $item->quantity
            ]);


            $item->delete();
        }

        $deliveryNote->delete();



        $flasher->addSuccess('Canceled');
        return redirect()->signedRoute('web.sales.deliverynote.report');
     }
}
