<?php

namespace App\Http\Controllers\web\sales;

use Illuminate\Http\Request;
use App\models\sales\Invoice;
use App\models\sales\InvoicesbyDelivery;
use App\Http\Controllers\Controller;
use App\models\sales\relation\ItemSaleableInvoiceByDelivery;
use Barryvdh\Snappy\Facades\SnappyPdf;
use Flasher\Toastr\Prime\ToastrFactory;
use Illuminate\Support\Facades\DB;

class InvoiceByDeliverNotesController extends Controller
{
     /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(InvoicesbyDelivery $invoice)
    {

        $delivery_notes = $invoice->deliveryNotes()->get();

        $data = compact(
            'invoice',
            'delivery_notes'
        );


        return view('sales.invoice_by_delivery.show.index', $data);
    }

    public function pdf(InvoicesbyDelivery $invoice)
    {

        $delivery_notes = $invoice->deliveryNotes()->get();

        $data = compact(
            'invoice',
            'delivery_notes'
        );


        return SnappyPdf::loadView('sales.invoice_by_delivery.pdf.invoice', $data)->inline('invoice.pdf');
    }

    public function print(InvoicesbyDelivery $invoice)
    {
        $delivery_notes = $invoice->deliveryNotes()->get();

        $data = compact(
            'invoice',
            'delivery_notes'
        );


        return view('sales.invoice_by_delivery.print.invoice', $data);
    }

    public function report(Request $request)
    {
        $company = request()->user()->company;

        $data = compact('company');


        return view('reports.invoices_by_delivery.index', $data);
    }


    public function cancel(InvoicesbyDelivery $invoice, ToastrFactory $flasher){


        $recipts = $invoice->receipts;

        if ($recipts->isEmpty()) {

            $items = $invoice->saleItens;

            foreach( $items as $item){

                  //verifcando o stock do produto;

                $onSotck = DB::table('stock_moves')->where('saleable_id', $item->saleable_id)->latest('created_at')->first();

                $update = DB::table('stock_moves')->where('saleable_id', $item->saleable_id)
                ->latest('created_at')->update([
                    'balance' =>$onSotck->balance + $item->quantity
                ]);


                $item->delete();
            }

            $invoice->forceDelete();

            $flasher->addSuccess('Canceled');
            return redirect()->signedRoute('web.sales.invoice.report.by.delivery');

        } else {

            $flasher->addError('A fatura ja foi emitida um recibo');
            return back();

        }


     }
}
