<?php

namespace App\Http\Controllers\web\sales;

use Illuminate\Http\Request;
use App\models\sales\Invoice;
use App\models\sales\InvoicesbyDelivery;
use App\Http\Controllers\Controller;
use App\models\sales\relation\ItemSaleableInvoiceByDelivery;
use Barryvdh\Snappy\Facades\SnappyPdf;
use Flasher\Toastr\Prime\ToastrFactory;
use Illuminate\Support\Facades\DB;

class InvoiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return $this->report(request());
        return view('sales.invoice.list.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {



        $user = request()->user();
        $brunch = $user->company;
        $invoice = $user->createInvoice();

        $invoicebydeliverynotes = $user->createInvoiceByDeliveryNotes();

        $saleables = $brunch->saleables()->with('vatScheme')->get();
        $warehouses = $brunch->warehouses;


        $customers = $brunch->customers()
            ->where('default', false)
            ->orWhere('default', 0)
            ->orWhere('default', null)

            ->with(['invoices' => function($query){
                // Precsisa ser elaborado. Para prever pagamentos parciais, notas de credito parciais, e notas de debito
                return $query
                    ->whereNotNull(Invoice::table().'.validated_at')
                    ->doesntHave('creditNotes')
                    ->doesnthave('receipts');
            }])
            ->get();

        $data = compact(
            'warehouses',
            'customers',
            'saleables',
            'invoice'
        );
        return view('sales.invoice.create.index', $data);
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Invoice $invoice)
    {
        $data = compact(
            'invoice'
        );

        return view('sales.invoice.show.index', $data);
    }

    public function pdf(Invoice $invoice)
    {
        $data = compact(
            'invoice'
        );
        return SnappyPdf::loadView('sales.invoice.pdf.invoice', $data)->inline('invoice.pdf');
    }

    public function print(Invoice $invoice)
    {
        $data = compact(
            'invoice'
        );
        return view('sales.invoice.print.invoice', $data);
    }

    public function report(Request $request)
    {
        $company = request()->user()->company;

        $data = compact('company');

        return view('reports.invoices.index', $data);
    }

    public function cancel(Invoice $invoice, ToastrFactory $flasher){



        $recipts = $invoice->receipts;

        if ($recipts->isEmpty()) {

            $items = $invoice->saleItens;

            foreach( $items as $item){

                  //verifcando o stock do produto;

                $onSotck = DB::table('stock_moves')->where('saleable_id', $item->saleable_id)->latest('created_at')->first();

                $update = DB::table('stock_moves')->where('saleable_id', $item->saleable_id)
                ->latest('created_at')->update([
                    'balance' =>$onSotck->balance + $item->quantity
                ]);


                $item->delete();
            }

            $invoice->forceDelete();

            $flasher->addSuccess('Cancelada');
            return redirect()->signedRoute('web.sales.invoice.report');

        } else {

            $flasher->addError('A fatura ja foi emitida um recibo');
            return back();

        }



    }
}
