<?php

namespace App\Http\Controllers\web\sales;

use Illuminate\Http\Request;
use App\models\sales\Proforma;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use Symfony\Component\HttpFoundation\Response;

class ProformaController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        return $this->report(request());

        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user = request()->user();
        $brunch = $user->company;
        $proforma = $user->createProforma();


        $saleables = $brunch->saleables()->with('vatScheme')->get();
        $customers = $brunch->customers;

        $data = compact(
            'customers',
            'saleables',
            'proforma'
        );
        return view('sales.proforma.create.index', $data);
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Proforma $proforma)
    {
        abort_if(!request()->user()->can('view', $proforma), Response::HTTP_FORBIDDEN);
        $data = compact(
            'proforma'
        );
        return view('sales.proforma.show.index', $data);
    }



    public function pdf(Proforma $proforma)
    {
        $data = compact(
            'proforma'
        );
        return SnappyPdf::loadView('sales.proforma.pdf.invoice', $data)->inline('proforma.pdf');
    }

    public function print(Proforma $proforma)
    {
        $data = compact(
            'proforma'
        );
        return view('sales.proforma.print.invoice', $data);
    }

    public function report(Request $request)
    {
        $company = request()->user()->company;
        $data = compact('company');
        return view('reports.proforma.index', $data);
    }
}
