<?php

namespace App\Http\Controllers\web\sales;

use Illuminate\Http\Request;
use App\models\sales\Receipt;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\models\sales\utils\PaymentMethod;

class ReceiptController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user   = request()->user();
        $brunch = $user->company;
        $recipt  = $user->createReceipt();

        $customers = $brunch->customers;

        $paymentMethods = PaymentMethod::where(
            [
                ['id', '<>', PaymentMethod::systemadvance()->id]
            ]
        )->get();

        $data = compact(
            'customers',
            'recipt',
            'paymentMethods'
        );
        return view('sales.receipt.create.index', $data);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Receipt $recipt)
    {
        $data = compact(
            'recipt'
        );

        // dd($recipt->recieptItems);

        return view('sales.receipt.show.index', $data);
    }

    public function print(Receipt $recipt)
    {
        $data = compact(
            'recipt'
        );
        return view('sales.receipt.print.index', $data);
    }

    public function pdf(Receipt $recipt)
    {
        $data = compact(
            'recipt'
        );
        return SnappyPdf::loadView('sales.receipt.pdf.index', $data)->inline('proforma.pdf');
    }

    public function report(Request $request)
    {
        $company = request()->user()->company;

        $data = compact('company');

        return view('reports.recipt.index', $data);
    }
}
