<?php

namespace App\Http\Controllers\web\sales;



use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Http\Requests\ReportGeneratorRequest;
use App\models\sales\Invoice;
use Barryvdh\DomPDF\Facade\Pdf;

class ReportController extends Controller
{
    public function generic(Request $request)
    {
        $company = request()->user()->company;
        $data = compact('company');
        return view('reports.generic.index', $data);
    }

    public function generate()
    {
        $company = request()->user()->company;
        $data = compact('company');
        return view('reports.generator.create.index', $data);
    }

    public function generatePDF(ReportGeneratorRequest $request)
    {

        $company = request()->user()->company;
        $from   = (new Carbon($request->input('period_from')))->startOfDay();
        $to     = (new Carbon($request->input('period_to')))->endOfDay();

        $reportDocuments = $request->input('documents');



        $basicsAmount = 0;
        $receiptsAmount = 0;
        $cashSalesAmount = 0;
        $invoicesAmount = 0;
        $deliveryAmount = 0;
        $invoiceBydeliveryAmount =0 ;

        $includeBasicSales = false;
        $includeReceipts = false;
        $includeCashSales = false;
        $includeInvoices  = false;
        $includeDelivery = false;
        $includeInvoicebydelivery = false;

        $tempItems = collect([]);

        // Vendas Básicas
        if (in_array(1, $reportDocuments)) {
            # code...
            $basicsAmount = sumSales($company->basicSalesPeriod(new Carbon($from), new Carbon($to))->get());
            $includeBasicSales = true;

            foreach ($company->basicsSalesItemsPeriod(new Carbon($from), new Carbon($to)) as $key => $value) {
              $tempItems->push($value);
            }


        }


        // Faturas
        if (in_array(2, $reportDocuments)) {
            $invoicesAmount = sumSales($company->invoicesPeriod(new Carbon($from), new Carbon($to))->get());
            $includeInvoices= true;

            foreach ($company->invoicesSalesItemsPeriod(new Carbon($from), new Carbon($to)) as $key => $value2) {
                $tempItems->push($value2);
              }

        }


        // Recibos
        if (in_array(3, $reportDocuments)) {
            # code...
            $receiptsAmount = sumSales($company->receiptsPeriod(new Carbon($from), new Carbon($to))->get());
            $includeReceipts = true;
        }
        // NC
        if (in_array(4, $reportDocuments)) {
            // Todo
        }
        // ND
        if (in_array(5, $reportDocuments)) {
            // Todo
        }
        // Venda Dinheiro
        if (in_array(6, $reportDocuments)) {
            $cashSalesAmount = sumSales($company->cashSalesPeriod(new Carbon($from), new Carbon($to))->get());
            $includeCashSales = true;
            foreach ($company->cashSalesItemsPeriod(new Carbon($from), new Carbon($to)) as $key => $value6) {
                $tempItems->push($value6);
              }

        }

        //Guias de Remessa
        if (in_array(7, $reportDocuments)) {

            $deliveryAmount = sumSales($company->deliveryNotesPeriod(new Carbon($from), new Carbon($to))->get());

            foreach ($company->deliveryNotesItemsPeriod(new Carbon($from), new Carbon($to)) as $key => $value7) {
                $tempItems->push($value7);
              }

            $includeDelivery = true;


        }


         //Facturas baseadas em guias

         if (in_array(8, $reportDocuments) || in_array(2,$reportDocuments)) {

            $invoiceBydeliveryAmount = sumSales($company->invoicesByDeliveryNotesPeriod(new Carbon($from), new Carbon($to))->get());

            foreach ($company->invoicesByDeliveryNotesItemsPeriod(new Carbon($from), new Carbon($to)) as $key => $value8) {
                $tempItems->push($value8);
              }

            $includeInvoicebydelivery = true;


        }




        $filterAllDuplicate = $tempItems->duplicates('sale_code')->unique();  //pgando todos codigos repitidos na nos items de todos documentos
        $allItems = collect([]);



        if (count($filterAllDuplicate )!=0) {


            foreach ($filterAllDuplicate as $key => $code) {
                $quantity = $tempItems->where('sale_code', $code)->sum('quantity');
                $total = $tempItems->where('sale_code', $code)->sum('total');
                $repitedItems = $tempItems->where('sale_code', $code)->first();

                $allItems->push((object)[
                    'sale_code'=>$repitedItems->sale_code,
                    'sale_name'=>$repitedItems->sale_name,
                    'saleable_id'=>$repitedItems->saleable_id,
                    'unit_amount' => $repitedItems->unit_amount,
                    'total'       =>$total,
                    'quantity'=>$quantity,
                ]);
            }

            $nomalItems = $tempItems->whereNotIn('sale_code', $filterAllDuplicate);

            foreach ($nomalItems as $key => $normal) {

                $allItems->push((object)$normal);
            }
        } else {
            $allItems = $tempItems; // caso nao haja códigos repetidos
        }




        $data = compact(
            'company',
            'from',
            'to',
            'basicsAmount',
            'receiptsAmount',
            'cashSalesAmount',
            'invoicesAmount',
            'deliveryAmount',
            'allItems',
            'invoiceBydeliveryAmount',



            'includeBasicSales',
            'includeReceipts',
            'includeCashSales',
            'includeInvoices',
            'includeDelivery',
            'includeInvoicebydelivery'
        );

       // ->setPaper('a4', 'landscape')

        $mytime = Carbon::now();
        $pdf = Pdf::loadView('reports.generator.pdf.index', $data);

        return $pdf->download('report '.$mytime.'.pdf');

        // return view('reports.generator.pdf.index', $data);
    }
}
