<?php

namespace App\Http\Controllers\web\sales;

use App\models\sales\Basic;
use App\Http\Controllers\Controller;

class ReturnSaleController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return (new BasicSaleController())->index();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user = request()->user();
        $brunch = $user->company;
        $return = $user->createBasicSale();
        $saleables = $brunch->saleables()->with('vatScheme')->get();
        $customers = $brunch->customers;

        $crm = false;
        if ($brunch->crmConfig) {
            if ($user->can('funcionality-crm', $brunch))
                $crm =  $brunch->crmConfig ? $brunch->crmConfig->isEnabled() : false;
        }

        $shifts = $brunch->shifts()->where('ended_at', null)->get();

        $data = compact(
            'customers',
            'saleables',
            'return',
            'crm',
            'shifts'
        );

        $fast = $brunch->basicSaleOption()->exists();
        if ($fast) {
            $fast = $brunch->basicSaleOption->fast_sale;
            if ($fast) {
                return view('sales.returns.create.fast.index', $data);
            }
        }

        return view('sales.returns.create.normal.index', $data);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Basic $return)
    {
        return (new BasicSaleController())->show($return);
    }

    public function print(Basic $return)
    {
        return (new BasicSaleController())->print($return);
    }
}
