<?php

namespace App\Http\Controllers\web\shifts;

use App\models\shifts\Shift;
use App\Http\Controllers\Controller;

class ShiftController extends Controller
{


    public function current()
    {
        $user = request()->user();
        $shift = $user->currentShift();
        return $this->show($shift);
    }


    public function opened()
    {
        $user = request()->user();
        $shifts = $user->company->shifts()->where('ended_at', null)->get();

        $data = compact(
            'shifts'
        );
        return view('shifts.shift.list.index', $data);
    }

    public function index()
    {
        $user = request()->user();
        $shifts = $user->company->shifts()->where('ended_at', '<>', null)->get();

        $data = compact(
            'shifts'
        );
        return view('shifts.shift.list.index', $data);
    }


    public function show(Shift $shift)
    {
        $data = compact(
            'shift'
        );
        return view('shifts.shift.show.index', $data);
    }

    public function thermal(Shift $shift)
    {
        $data = compact('shift');
        return view('shifts.print.thermal.index', $data);
    }
    public function pdf(Shift $shift)
    {
    }
    public function basic(Shift $shift)
    {
    }
    public function cashsale(Shift $shift)
    {
    }
    public function invoice(Shift $shift)
    {
    }
    public function debitnote(Shift $shift)
    {
    }
    public function creditnote(Shift $shift)
    {
    }
    public function recipt(Shift $shift)
    {
    }
}
