<?php

namespace App\Http\Controllers\web\stock;

use App\models\stock\Category;
use App\Http\Controllers\Controller;

class CategoryController extends Controller
{
     /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $brunch = request()->user()->company;
        $categories = $brunch->categories;
        $data = compact(
            'categories'
        );
        return view('stock.category.list.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('stock.category.create.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Category $category)
    {
        $data = compact('category');
        return view('stock.category.show.index', $data);
    }
}
