<?php

namespace App\Http\Controllers\web\stock;

use App\models\stock\Provider;
use App\Http\Controllers\Controller;

class ProviderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $brunch = request()->user()->company;
        $providers = $brunch->providers;
        $data = compact(
            'providers'
        );
        return view('stock.provider.list.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $company    = request()->user()->company;
        $customers  = $company->customers;
        $data       = compact( 'customers');
        return view('stock.provider.create.index', $data);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Provider $provider)
    {
        $company    = request()->user()->company;
        $customers  = $company->customers;
        $data       = compact('provider', 'customers');
        return view('stock.provider.show.index', $data);
    }
}
