<?php

namespace App\Http\Controllers\web\stock;

use App\models\stock\Saleable;
use App\models\stock\VatScheme;
use App\Http\Controllers\Controller;
use Symfony\Component\HttpFoundation\Response;

class SaleableController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $brunch = request()->user()->company;
        $saleables = $brunch->saleables;


        $data = compact(
            'saleables'
        );
        return view('stock.saleable.list.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $brunch = request()->user()->company;
     
        $saleunits = $brunch->saleUnits;
        $vatschemes = VatScheme::all();
        $categories = $brunch->categories;


        $data = compact(
            'saleunits',
            'categories',
            'vatschemes',
        );
        return view('stock.saleable.create.index', $data);
    }




    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Saleable $saleable)
    {
        abort_if(!request()->user()->can('view', $saleable), Response::HTTP_FORBIDDEN);



        $brunch = request()->user()->company;
        $saleunits = $brunch->saleUnits;
        $warehouses = $brunch->warehouses;

        $vatschemes = VatScheme::all();


        $categories = $brunch->categories;

        $data = compact(
            'saleable',
            'brunch',
            'saleunits',
            'categories',
            'vatschemes',
            'warehouses'
        );
        return view('stock.saleable.show.index', $data);
    }
}
