<?php

namespace App\Http\Controllers\web\stock;

use Illuminate\Http\Request;
use App\models\stock\Category;
use App\models\stock\Saleable;
use App\models\stock\Warehouse;
use App\Http\Controllers\Controller;
use Symfony\Component\HttpFoundation\Response;
use App\Http\Requests\stock\StockMoveFilterRequest;
use Illuminate\Support\Facades\DB;

class StockMoveController extends Controller
{

    public function inventory()
    {
        $brunch = request()->user()->company;
        $warehouses = $brunch->warehouses;
        $categories = $brunch->categories;

        $data = compact(
            'categories',
            'warehouses'
        );
        return view('stock.stockmove.inventory.index', $data);
    }

    public function toolslist()
    {
        $brunch = request()->user()->company;
        $warehouses = $brunch->warehouses;
        $categories = $brunch->categories;

        $data = compact(
            'categories',
            'warehouses'
        );
        return view('stock.stockmove.inventory.toolslist.index', $data);
    }

   public function stockbyqty()
   {
       $brunch = request()->user()->company;
       $warehouses = $brunch->warehouses;
       $categories = $brunch->categories;

       $data = compact(
           'categories',
           'warehouses'
       );
       return view('stock.stockmove.inventory.toolslist.stockbyqty.index', $data);
   }

   public function expiredsaleable()
   {
       $brunch = request()->user()->company;
       $warehouses = $brunch->warehouses;
       $categories = $brunch->categories;

       $data = compact(
           'categories',
           'warehouses'
       );
       return view('stock.stockmove.inventory.toolslist.expired_product.index', $data);
   }

    public function thermal(StockMoveFilterRequest $request)
    {
        $warehouse = Warehouse::find($request->input('warehouse'));
        abort_if(!request()->user()->can('view', $warehouse), Response::HTTP_FORBIDDEN);
        $categories = null;

        if ($request->filled('categories')) {
            $categories = request()->user()->company->categories()->whereIn(Category::table() . '.id', $request->input('categories'))->get();
        }

        if (!$categories)
            $categories = $warehouse->categoriesInventory();


        $categories = $categories->sortBy('name');
        $data = compact(
            'categories',
            'warehouse'
        );


        return view('stock.stockmove.inventory.thermal.index', $data);
    }
    public function a4(StockMoveFilterRequest $request)
    {
        $warehouse = Warehouse::find($request->input('warehouse'));
        abort_if(!request()->user()->can('view', $warehouse), Response::HTTP_FORBIDDEN);

        $categories = null;

        if ($request->filled('categories')) {
            $categories = request()->user()->company->categories()->where(Category::table() . '.id', 'in', $request->input('categories'))->get();
        }

        if (!$categories)
            $categories = $warehouse->categoriesInventory();

        $data = compact(
            'categories',
            'warehouse'
        );

        // return 'generating A4 pdf';
        return view('stock.stockmove.inventory.thermal.index', $data);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return $this->inventory();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $brunch = request()->user()->company;
        $warehouses = $brunch->warehouses;
        $providers = $brunch->providers;
        $saleables = $brunch->saleables()->where('is_stockable', true)->get();




        $saleables->transform(function(Saleable $item){

             //verifcando o stock do produto;

            $onSotck = DB::table('stock_moves')->where('saleable_id', $item->id)->latest('created_at')->first();

            $move = $item->lastStockMove();
            $item->last_price = $move? $move->unit_price : 0;
            $item->last_qty = $onSotck? number_format($onSotck->balance) : 0;
            return $item;
        });

        $data = compact(
            'warehouses',
            'saleables',
            'providers'
        );


        return view('stock.stockmove.create.index', $data);
    }

    public function  adjust()
    {
        $brunch = request()->user()->company;
        $warehouses = $brunch->warehouses;
        $saleable = $brunch->saleables()->where('is_stockable', true)->get();
        $saleables = collect([]);

        // $brunch->LastStock();

        foreach ($saleable as $key => $prod) {
            $stock  = $brunch->LastStock($prod->id);
            $saleables->push((object)[
                'id' => $prod->id,
                'name'=>$prod->name,
                'stock'=>$stock,
                'price'=>$prod->price,
                'code'=>$prod->code
            ]);
        }

        // dd($saleables);

        $data = compact(
            'warehouses',
            'saleables'
        );


        return view('stock.stockmove.adjust.index', $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
